
/**
 ******************************************************************************
 *
 * @file        MG32x02z_TM26OC1HOutput_API.c
 * @brief       Control TM26 OC1H to output audio data. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* audio file is 'whe16_8B8K.c' */


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_TM26OC1H_Output_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
TM_HandleTypeDef    hTM26;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern uint8_t rawData[];
extern uint8_t TM10_OVF;


/**
 *******************************************************************************
 * @brief       Initial LM35DZ 
 * @param[in]   None
 * @return		None
 *******************************************************************************
 */
void API_TM26OC1H_Output_Init(void)
{
    TM_ClockConfigTypeDef   CKConfig;
    TM_OC_InitTypeDef       sConfig;        // OC config
    
    
        
    // ------------------------------------------------------------------------
    // 1.Initial TM26 timer : counter range is 8K in 48MHz.
    // ------------------------------------------------------------------------
    hTM26.Instance                  = TM26;
    hTM26.Init.TM_CounterMode       = TM_CASCADE_UP;
    hTM26.Init.TM_Period            = 255;             
    hTM26.Init.TM_Prescaler         = 0;
    MID_TM_Base_Init(&hTM26);
    
    // ------------------------------------------------------------------------
    // 2.Initial TM26 clock mode.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    MID_TM_ConfigClockSource(&hTM26, &CKConfig);  

    // ------------------------------------------------------------------------
    // 3.Initial TM26_OC1H for 8bit PWM mode configuration.
    // ------------------------------------------------------------------------
    MID_TM_OC_Struct_Init(&sConfig);
    sConfig.OCMode = TM_CH_8bitx2_PWM;
    sConfig.Pulse = 0;                          // Turn off LEDs
    MID_TM_PWM_ConfigChannel(&hTM26, &sConfig, MID_TM_Channel0);

    sConfig.Pulse = 0;                          // Audio L output : 0%
    MID_TM_PWM_ConfigChannel(&hTM26, &sConfig, MID_TM_Channel1);

    // ------------------------------------------------------------------------
    // Enable 8bitx2 PWM output 
    // ------------------------------------------------------------------------
    MID_TM_8Bx2PWM_Start(&hTM26, MID_TM_Channel0);     
    MID_TM_8Bx2PWM_Start(&hTM26, MID_TM_Channel1);     
}


